function [acv,ac]=AutoCrossD(d,names,nLag)
%	AUTOCROSSD - [acv,ac]=AutoCrossD(d,names,nLag)
%	Constructs auto-cross covariances and correlations
%	WARNING: series are NOT demeaned
%	For x(t) a column vector, elements of ac and acv are based on Ex(t)' x(t-lag)
nVar = length(names);
acv = zeros(nVar,nVar,nLag+1);
ac = acv;
nUsed = zeros(nLag+1,1);

for i=1:length(d)
   
   for j=1:nVar
      v = names{j};
      z = getfield(d(i),v);
      lenz = length(z);
      zcols = size(z,2);
      if zcols>1
         z = reshape(z,lenz,1);
      end
      if j==1
         n = lenz;
         x=zeros(n,nVar);
      end
      
      % If variables are of different lengths, the first observations are truncated.
      if lenz<n
         x=x((n-lenz+1):end,:);
         n = lenz;
      elseif lenz>n
         z = z((lenz-n+1):end);
      end
      
      x(:,j) = z;
   end
   
	for iLag=0:nLag
      m = n-iLag;
      if m>0
         nUsed(iLag+1) = nUsed(iLag+1) + m;
         cp = transpose(x((iLag+1):end,:))*x(1:(n-iLag),:);
         acv(:,:,iLag+1) = acv(:,:,iLag+1) + cp;
      end
	end         
   
end

for i=1:nLag+1
   acv(:,:,i) = acv(:,:,i)/nUsed(i);
   if i==1
      r = diag(1./sqrt(diag(acv(:,:,1))));
   end
   ac(:,:,i) = r*acv(:,:,i)*r;
end   
